/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.ponder.scenes;

import com.mojang.authlib.GameProfile;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRItems;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.EntityElement;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2631;
import net.minecraft.class_2665;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_8080;

public class ConductorScenes {
    public static ElementLink<EntityElement> makePlayerStand(SceneBuilder scene, String playerName, int leatherColor, class_243 pos) {
        class_1799 playerHead = new class_1799((class_1935)class_1802.field_8575);
        GameProfile gameprofile = new GameProfile(null, playerName);
        class_2631.method_11335((GameProfile)gameprofile, profile -> {
            class_2487 itemTag = playerHead.method_7948();
            itemTag.method_10566("SkullOwner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)profile));
            playerHead.method_7980(itemTag);
        });
        ElementLink player = scene.world().createEntity(w -> {
            class_1531 entity = (class_1531)class_1299.field_6131.method_5883(w);
            entity.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            entity.field_6014 = pos.field_1352;
            entity.field_6036 = pos.field_1351;
            entity.field_5969 = pos.field_1350;
            class_8080 animation = entity.field_42108;
            animation.method_48568(-animation.method_48569(), 1.0f);
            animation.method_48567(1.0f);
            entity.field_5982 = 210.0f;
            entity.method_36456(210.0f);
            entity.field_6259 = 210.0f;
            entity.field_6241 = 210.0f;
            entity.method_5648(true);
            return entity;
        });
        scene.world().modifyEntity(player, entity -> {
            entity.method_5673(class_1304.field_6169, playerHead);
            class_2487 leatherTag = new class_2487();
            class_2487 displayTag = new class_2487();
            displayTag.method_10569("color", leatherColor);
            leatherTag.method_10566("display", (class_2520)displayTag);
            class_1799 chestplate = new class_1799((class_1935)class_1802.field_8577);
            class_1799 leggings = new class_1799((class_1935)class_1802.field_8570);
            class_1799 boots = new class_1799((class_1935)class_1802.field_8370);
            chestplate.method_7980(leatherTag);
            leggings.method_7980(leatherTag);
            boots.method_7980(leatherTag);
            entity.method_5673(class_1304.field_6174, chestplate);
            entity.method_5673(class_1304.field_6172, leggings);
            entity.method_5673(class_1304.field_6166, boots);
        });
        return player;
    }

    public static ElementLink<EntityElement> makeConductor(SceneBuilder scene, class_1767 color, class_243 pos) {
        return scene.world().createEntity(w -> {
            ConductorEntity entity = (ConductorEntity)CREntities.CONDUCTOR.create(w);
            entity.setColor(color);
            entity.method_5673(class_1304.field_6169, CRItems.ITEM_CONDUCTOR_CAP.get(color).asStack());
            entity.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            entity.field_6014 = pos.field_1352;
            entity.field_6036 = pos.field_1351;
            entity.field_5969 = pos.field_1350;
            class_8080 animation = entity.field_42108;
            animation.method_48568(-animation.method_48569(), 1.0f);
            animation.method_48567(1.0f);
            entity.field_5982 = 210.0f;
            entity.method_36456(210.0f);
            entity.field_6259 = 210.0f;
            entity.field_6241 = 210.0f;
            return entity;
        });
    }

    public static void constructing(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("conductor_constructing", "Constructing a Conductor");
        scene.configureBasePlate(0, 0, 3);
        scene.scaleSceneView(1.0f);
        scene.showBasePlate();
        scene.rotateCameraY(85.0f);
        scene.idle(10);
        class_2338 casing = util.grid().at(1, 1, 1);
        class_2338 deployer = util.grid().at(1, 3, 1);
        class_2338 cog = util.grid().at(1, 3, 2);
        scene.world().showSection(util.select().position(casing), class_2350.field_11033);
        scene.overlay().showText(60).pointAt(util.vector().topOf(casing)).attachKeyFrame().placeNearTarget().text("Conductors are constructed with an andesite casing.");
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(casing, class_2350.field_11036), Pointing.DOWN, 40).rightClick().withItem(CRItems.ITEM_CONDUCTOR_CAP.get(class_1767.field_7964).asStack());
        scene.idle(50);
        scene.world().showSection(util.select().position(deployer), class_2350.field_11033);
        scene.world().showSection(util.select().position(cog), class_2350.field_11043);
        scene.world().setKineticSpeed(util.select().position(cog), 16.0f);
        scene.idle(5);
        scene.world().moveDeployer(deployer, 1.0f, 25);
        scene.idle(26);
        scene.world().destroyBlock(casing);
        ElementLink<EntityElement> conductor = ConductorScenes.makeConductor((SceneBuilder)scene, class_1767.field_7964, class_243.method_24955((class_2382)casing));
        scene.world().moveDeployer(deployer, -1.0f, 25);
        scene.idle(30);
        scene.world().hideSection(util.select().position(cog), class_2350.field_11035);
        scene.world().hideSection(util.select().position(deployer), class_2350.field_11036);
    }

    public static void redstoning(SceneBuilder scene, SceneBuildingUtil util) {
        int finalI;
        int finalI2;
        int finalI3;
        scene.title("conductor_redstoning", "Remote Redstone with Conductors");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(1.0f);
        scene.showBasePlate();
        scene.rotateCameraY(85.0f);
        scene.idle(10);
        class_2338 button = util.grid().at(3, 1, 0);
        class_2338 corner = util.grid().at(5, 1, 0);
        class_2338 lamp = util.grid().at(5, 1, 5);
        class_2338 buttonConductorPos = util.grid().at(4, 1, 1);
        ElementLink<EntityElement> buttonConductor = ConductorScenes.makeConductor(scene, class_1767.field_7964, class_243.method_24955((class_2382)buttonConductorPos));
        scene.world().modifyEntity(buttonConductor, entity -> entity.method_5702(class_2183.class_2184.field_9851, class_243.method_24953((class_2382)button)));
        for (int x = 3; x <= 5; ++x) {
            scene.world().showSection(util.select().position(util.grid().at(x, 1, 0)), class_2350.field_11033);
            scene.idle(2);
        }
        for (int z = 1; z <= 5; ++z) {
            scene.world().showSection(util.select().position(util.grid().at(5, 1, z)), class_2350.field_11033);
            scene.idle(2);
        }
        scene.overlay().showText(50).pointAt(util.vector().topOf(buttonConductorPos)).attachKeyFrame().placeNearTarget().text("Conductors can press buttons when a player looks at them.");
        scene.idle(20);
        ElementLink<EntityElement> player = ConductorScenes.makePlayerStand(scene, "Slimeist", 65280, class_243.method_24955((class_2382)util.grid().at(2, 1, 2)));
        scene.world().modifyEntity(player, entity -> entity.method_5702(class_2183.class_2184.field_9851, class_243.method_24953((class_2382)buttonConductorPos.method_10087(2))));
        scene.idle(15);
        int i = 0;
        while (i <= 20) {
            finalI3 = i++;
            scene.world().modifyEntity(player, entity -> {
                class_1531 stand = (class_1531)entity;
                stand.method_6919(new class_2379((float)finalI3, 0.0f, 0.0f));
            });
            scene.idle(1);
        }
        scene.idle(20);
        scene.overlay().showBigLine(PonderPalette.RED, util.vector().centerOf(util.grid().at(2, 2, 2)), util.vector().topOf(buttonConductorPos), 40);
        scene.world().toggleRedstonePower(util.select().fromTo(button, corner));
        scene.world().toggleRedstonePower(util.select().fromTo(corner.method_10072(), lamp));
        scene.effects().indicateRedstone(button);
        scene.idle(30);
        for (i = 20; i > 0; --i) {
            finalI3 = i;
            scene.world().modifyEntity(player, entity -> {
                class_1531 stand = (class_1531)entity;
                stand.method_6919(new class_2379((float)finalI3, 0.0f, 0.0f));
            });
            scene.idle(1);
            if (i == 10) {
                scene.world().toggleRedstonePower(util.select().fromTo(button, corner));
                scene.world().toggleRedstonePower(util.select().fromTo(corner.method_10072(), lamp.method_10095()));
            }
            if (i != 6) continue;
            scene.world().toggleRedstonePower(util.select().position(lamp));
        }
        scene.rotateCameraY(-85.0f);
        scene.idle(30);
        class_2338 piston = util.grid().at(0, 1, 5);
        class_2338 lever = util.grid().at(1, 1, 5);
        scene.world().showSection(util.select().position(piston), class_2350.field_11033);
        scene.idle(30);
        scene.world().showSection(util.select().position(lever), class_2350.field_11039);
        class_2338 leverConductorPos = util.grid().at(3, 1, 5);
        scene.idle(10);
        ElementLink<EntityElement> leverConductor = ConductorScenes.makeConductor(scene, class_1767.field_7966, class_243.method_24955((class_2382)leverConductorPos));
        scene.world().modifyEntity(leverConductor, entity -> entity.method_5702(class_2183.class_2184.field_9851, class_243.method_24953((class_2382)lever)));
        scene.overlay().showText(30).pointAt(util.vector().topOf(leverConductorPos)).attachKeyFrame().placeNearTarget().text("Conductors also toggle levers when a player looks at them.");
        scene.idle(35);
        scene.world().modifyEntity(player, entity -> {
            entity.method_5702(class_2183.class_2184.field_9851, class_243.method_24953((class_2382)leverConductorPos));
            class_1531 stand = (class_1531)entity;
            stand.method_6919(new class_2379(entity.method_36455(), 0.0f, 0.0f));
        });
        scene.idle(2);
        scene.overlay().showBigLine(PonderPalette.BLUE, util.vector().centerOf(util.grid().at(2, 2, 2)), util.vector().topOf(leverConductorPos), 40);
        scene.world().toggleRedstonePower(util.select().position(lever));
        scene.effects().indicateRedstone(lever);
        scene.world().modifyBlock(piston, state -> (class_2680)state.method_11657((class_2769)class_2665.field_12191, (Comparable)Boolean.valueOf(true)), false);
        scene.world().showSection(util.select().position(util.grid().at(0, 2, 5)), class_2350.field_11036);
        scene.world().setBlock(piston.method_10084(), (class_2680)class_2246.field_10379.method_9564().method_11657((class_2769)class_2671.field_10927, (Comparable)class_2350.field_11036), false);
        scene.idle(30);
        int i2 = 0;
        while (i2 <= 10) {
            finalI2 = i2++;
            scene.world().modifyEntity(player, entity -> {
                class_1531 stand = (class_1531)entity;
                stand.method_6919(new class_2379(entity.method_36455(), (float)finalI2 * 3.5f, 0.0f));
            });
            scene.idle(1);
        }
        scene.idle(10);
        scene.world().modifyEntity(player, entity -> entity.method_5673(class_1304.field_6169, CRItems.ITEM_CONDUCTOR_CAP.get(class_1767.field_7964).asStack()));
        scene.overlay().showText(30).pointAt(util.vector().topOf(util.grid().at(2, 1, 2))).attachKeyFrame().placeNearTarget().text("Conductors do not activate redstone if a player is wearing a different-colored cap from them.");
        scene.idle(25);
        i2 = 10;
        while (i2 > 0) {
            finalI2 = i2--;
            scene.world().modifyEntity(player, entity -> {
                class_1531 stand = (class_1531)entity;
                stand.method_6919(new class_2379(entity.method_36455(), (float)finalI2 * 3.5f, 0.0f));
            });
            scene.idle(1);
        }
        class_243 playerPoint = util.vector().centerOf(util.grid().at(2, 2, 2));
        class_243 conductorPoint = util.vector().topOf(leverConductorPos);
        class_243 middlePoint = playerPoint.method_1019(conductorPoint).method_1021(0.5);
        scene.overlay().showLine(PonderPalette.RED, playerPoint, middlePoint, 40);
        scene.overlay().showLine(PonderPalette.BLUE, conductorPoint, middlePoint, 40);
        scene.idle(45);
        scene.world().modifyEntity(player, entity -> {
            entity.method_5702(class_2183.class_2184.field_9851, class_243.method_24953((class_2382)buttonConductorPos.method_10087(2)));
            ((class_1531)entity).method_6919(new class_2379(0.0f, 0.0f, 0.0f));
        });
        scene.idle(15);
        int i3 = 0;
        while (i3 <= 20) {
            finalI = i3++;
            scene.world().modifyEntity(player, entity -> {
                class_1531 stand = (class_1531)entity;
                stand.method_6919(new class_2379((float)finalI, 0.0f, 0.0f));
            });
            scene.idle(1);
        }
        scene.idle(20);
        scene.overlay().showBigLine(PonderPalette.RED, util.vector().centerOf(util.grid().at(2, 2, 2)), util.vector().topOf(buttonConductorPos), 40);
        scene.world().toggleRedstonePower(util.select().fromTo(button, corner));
        scene.world().toggleRedstonePower(util.select().fromTo(corner.method_10072(), lamp));
        scene.effects().indicateRedstone(button);
        scene.idle(30);
        for (i3 = 20; i3 > 0; --i3) {
            finalI = i3;
            scene.world().modifyEntity(player, entity -> {
                class_1531 stand = (class_1531)entity;
                stand.method_6919(new class_2379((float)finalI, 0.0f, 0.0f));
            });
            scene.idle(1);
            if (i3 == 10) {
                scene.world().toggleRedstonePower(util.select().fromTo(button, corner));
                scene.world().toggleRedstonePower(util.select().fromTo(corner.method_10072(), lamp.method_10095()));
            }
            if (i3 != 6) continue;
            scene.world().toggleRedstonePower(util.select().position(lamp));
        }
    }

    public static void toolboxing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("conductor_toolboxing", "Toolbox Transport with Conductors");
        scene.configureBasePlate(0, 0, 3);
        scene.scaleSceneView(1.0f);
        scene.showBasePlate();
        scene.rotateCameraY(85.0f);
        scene.idle(10);
        class_2338 conductorPos = util.grid().at(1, 1, 1);
        ElementLink<EntityElement> buttonConductor = ConductorScenes.makeConductor(scene, class_1767.field_7964, class_243.method_24955((class_2382)conductorPos));
        scene.overlay().showText(40).pointAt(util.vector().topOf(conductorPos)).attachKeyFrame().placeNearTarget().text("Toolboxes function normally when equipped on Conductors.");
        scene.idle(45);
        class_1799 toolboxStack = AllBlocks.TOOLBOXES.get(class_1767.field_7961).asStack();
        scene.overlay().showControls(util.vector().topOf(conductorPos), Pointing.DOWN, 40).rightClick().withItem(toolboxStack);
        scene.idle(35);
        scene.world().modifyEntity(buttonConductor, entity -> ((ConductorEntity)((Object)entity)).equipToolbox(toolboxStack));
        int i = 0;
        while (i <= 72) {
            int finalI = i++;
            scene.world().modifyEntity(buttonConductor, entity -> {
                entity.method_36456((float)finalI * 5.0f + 210.0f);
                entity.method_5636((float)finalI * 5.0f + 210.0f);
                entity.method_5847((float)finalI * 5.0f + 210.0f);
                entity.method_22862();
            });
            scene.idle(1);
        }
        scene.overlay().showControls(util.vector().topOf(conductorPos), Pointing.DOWN, 20).rightClick().whileSneaking();
        scene.idle(15);
        scene.world().modifyEntity(buttonConductor, entity -> ((ConductorEntity)((Object)entity)).unequipToolbox());
        scene.world().createItemEntity(util.vector().of(1.0, 1.0, 1.0), class_243.field_1353, toolboxStack);
    }
}

